function echo_inputs()

% Echos the inputs provided.

% global variables

global beta plr Pr_data x_data n NA NY NW jstate

% report inputs

disp('==============')
disp('Part 0: Inputs')
disp('==============')
disp(' ')
disp('--------------------')
disp('0. Config Parameters')
disp('--------------------')
disp(' ')
disp('a. Number of actions')
disp(' ')
disp([' NA(1) = ',num2str(NA(1))])
disp([' NA(2) = ',num2str(NA(2))])
disp(' ')
disp('b. Number of signals')
disp(' ')
disp([' NY(1) = ',num2str(NY(1))])
disp([' NY(2) = ',num2str(NY(2))])
disp(' ')
disp('c. Number of states')
disp(' ')
disp([' NW(1) = ',num2str(NW(1))])
disp([' NW(2) = ',num2str(NW(2))])
disp(' ')
disp('-------------------')
disp('1. Model Parameters')
disp('-------------------')
disp(' ')
disp('a. Discount factor')
disp(' ')
disp([' beta = ',num2str(beta)])
disp(' ')
disp('b. Period payoffs')
disp(' ')

for i=1:2

   for ai=1:NA(i); for yi=1:NY(i)

      i_s = num2str(i);
      ai_s = num2str(ai);
      yi_s = num2str(yi);

      disp([' u',i_s,'(a',i_s,'=',ai_s,',y',i_s,'=',yi_s,') = ', ...
            num2str(plr(i).u(ai,yi))])

   end; end

   disp(' ')

end

disp('c. Signal probabilities')
disp(' ')

for a1=1:NA(1); for a2=1:NA(2)

   for y1=1:NY(1); for y2=1:NY(2)

      a1_s = num2str(a1);
      a2_s = num2str(a2);
      y1_s = num2str(y1);
      y2_s = num2str(y2);

      disp([' P(y1=',y1_s,',y2=',y2_s,'|a1=',a1_s,',a2=',a2_s,') = ', ...
            num2str(Pr_data(y1,y2,a1,a2))])

   end; end

   disp(' ')

end; end

disp('d. Correlation device')
disp(' ')

for s1=1:NW(1); for s2=1:NW(2)
    
    s1_s = num2str(s1);
    s2_s = num2str(s2);
    
    disp([' x(s1=',s1_s,',s2=',s2_s,') = ', num2str(x_data(s1,s2))])
    
end; end
  
disp(' ')
disp('----------------------')
disp('2. Strategy Parameters')
disp('----------------------')
disp(' ')
disp('a. Action probabilities')
disp(' ')

for i=1:2

   for wi=1:NW(i); for ai=1:NA(i) 

      i_s = num2str(i);
      ai_s = num2str(ai);
      wi_s = num2str(wi);

      disp([' p',i_s,'(a',i_s,'=',ai_s,'|w',i_s,'=',wi_s,') = ', ...
            num2str(plr(i).p(ai,wi))])

   end; end

   disp(' ')

end

disp('b. State transition rules')
disp(' ')

for i=1:2; for wi=1:NW(i)

   for ai=1:NA(i); for yi=1:NY(i)

      i_s = num2str(i);
      wi_s = num2str(wi);
      ai_s = num2str(ai);
      yi_s = num2str(yi);

      disp([' w',i_s,'+(w',i_s,'=',wi_s,',a',i_s,'=',ai_s,',y',i_s,'=',yi_s,') = ', ...
            num2str(plr(i).wp(wi,ai,yi))])

   end; end

   disp(' ')

end; end

disp('c. Initial states')
disp(' ')

for i=1:2
  
  for si=1:NW(i)
    
    i_s = num2str(i);
    si_s = num2str(si);
    
    disp([' w_{0,',i_s,'}(s',i_s,'=',si_s,') = ', num2str(plr(i).w0(si))])
    
  end

  disp(' ')
  
end